const express = require("express");
const TipoUsuarioController = require("../controllers/tipousuario.controller");

const router = express.Router();

/**
 * @swagger
 * components:
 *   schemas:
 *     TipoUsuario:
 *       type: object
 *       required:
 *         - Nombre
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del tipo usuario
 *         Nombre:
 *           type: string
 *           description: Tipo de usuario que usara el sistema
 *       example:
 *         id: "1"
 *         Nombre: "Administrador🔑"
 */
/**
 * @swagger
 * tags:
 *   name: TipoUsuario
 *   description: API para gestionar tipos de usuario
 */
/**
 * @swagger
 * /generales/tipousuario:
 *   get:
 *     summary: Obtiene la lista de tipos de Usuario
 *     tags: [TipoUsuario]
 *     responses:
 *       200:
 *         description: Lista de tipos de Usuario.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/TipoUsuario'
 */
router.get(
    "/",
    TipoUsuarioController.getTipoUsuarioAll
);
/**
 * @swagger
 * /generales/tipousuario/{id}:
 *   get:
 *     summary: Obtiene un tipo de usuario por ID
 *     tags: [TipoUsuario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del tipo de usuario
 *     responses:
 *       200:
 *         description: Tipo Usuario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/TipoUsuario'
 *       404:
 *         description: Tipo Usuario no encontrado.
 */
router.get(
    "/:id",
    TipoUsuarioController.getTipoUsuarioById
);
/**
 * @swagger
 * /generales/tipousuario/create:
 *   post:
 *     summary: Crea un nuevo Tipo Usuario
 *     tags: [TipoUsuario]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/TipoUsuario'
 *     responses:
 *       201:
 *         description: Tipo Usuario creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/TipoUsuario'
 */
router.post(
    "/create",
    TipoUsuarioController.createTipoUsuario
);
/**
 * @swagger
 * /generales/tipousuario/update/{id}:
 *   put:
 *     summary: Actualiza un Tipo Usuario existente
 *     tags: [TipoUsuario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Tipo Usuario a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/TipoUsuario'
 *     responses:
 *       200:
 *         description: Tipo Usuario actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/TipoUsuario'
 *       404:
 *         description: Tipo Usuario no encontrado.
 */
router.put(
    "/update/:id",
    TipoUsuarioController.updateTipoUsuario
);
/**
 * @swagger
 * /generales/tipousuario/{id}:
 *   delete:
 *     summary: Elimina un Tipo Usuario por ID
 *     tags: [TipoUsuario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Tipo Usuario a eliminar
 *     responses:
 *       200:
 *         description: Tipo Usuario eliminado exitosamente.
 *       404:
 *         description: Tipo Usuario no encontrado.
 */
router.delete(
    "/:id",
    TipoUsuarioController.deleteTipoUsuario
);

module.exports = router;