// Importaciones necesarias
const express = require("express");
const dotenv = require("dotenv");
const cors = require("cors");
const helmet = require("helmet");
const xss = require("xss-clean");
const morgan = require("morgan");
const path = require('path');
const mongoSanitize = require("express-mongo-sanitize");
// connecion con la base de datos
const { sequelize } = require("./models");
// configuracion de swagger
const swaggerDocs = require("./config/swagger");
// configuracion de logger
const logger = require("./middlewares/logger.middleware");
// ruta para poder ver los logs
const logRoutes = require("./routes/logs.routes");
// ruta para los datos
const dataRoutes = require("./routes/data.routes");
const datosRoutes = require("./routes/datos.routes");
// rutas para los generales
const estadoagendamientoRoutes = require("./routes/estadoagendamiento.routes");
const estadoincidenciaRoutes = require("./routes/estadoincidencia.routes");
const estadopagoRoutes = require("./routes/estadopago.routes");
const estadocampaniaRoutes = require("./routes/estadocampania.routes");
const estadoordenlaboratorioRoutes = require("./routes/estadoordenlaboratorio.routes");
const estadousuarioRoutes = require("./routes/estadousuario.routes");
const fuentecaptacionRoutes = require("./routes/fuentecaptacion.routes");
const generoRoutes = require("./routes/genero.routes");
const gradoinstruccionRoutes = require("./routes/gradoinstruccion.routes");
const relacionRoutes = require("./routes/relacion.routes");
const vinculacionRoutes = require("./routes/vinculacion.routes");
const tipoafiliacionRoutes = require("./routes/tipoafiliacion.routes");
const tipodocumentoRoutes = require("./routes/tipodocumento.routes");
const tipoincidenciaRoutes = require("./routes/tipoincidencia.routes");
const tipopagoRoutes = require("./routes/tipopago.routes");
const tipoingresoRoutes = require("./routes/tipoingreso.routes");
const tipoproveedorRoutes = require("./routes/tipoproveedor.routes");
const tipocampaniaRoutes = require("./routes/tipocampania.routes");
const tipoactividadRoutes = require("./routes/tipoactividad.routes");
const tiporespuestaRoutes = require("./routes/tiporespuesta.routes");
const tipousuarioRoutes = require("./routes/tipousuario.routes");
const periodoRoutes = require("./routes/periodo.routes");
const iafaRoutes = require("./routes/iafa.routes");
// rutas para los pilares
const servicioRoutes = require("./routes/servicio.routes");
const profecionRoutes = require("./routes/profesion.routes");
const cargousuarioRoutes = require("./routes/cargousuario.routes");
const empresaRoutes = require("./routes/empresa.routes");
const sedeRoutes = require("./routes/sede.routes");
const consultorioRoutes = require("./routes/consultorio.routes");
// rutas para las incidencias
const clienteRoutes = require("./routes/cliente.routes");
const incidenciaRoutes = require("./routes/incidencia.routes");
const incidenciadetalleRoutes = require("./routes/incidenciadetalle.routes");
const accionRoutes = require("./routes/accion.routes");
// rutas para las encuestas
const encuestasimpleRoutes = require("./routes/encuestasimple.routes");
const encuestakidsRoutes = require("./routes/encuestakids.routes");
const encuestacomplejaRoutes = require("./routes/encuestacompleja.routes");
// rutas para patrimonio
const categoriapatrimonioRoutes = require("./routes/categoriapatrimonio.routes");
const subcategoriapatrimonioRoutes = require("./routes/subcategoriapatrimonio.routes");
const patrimonioRoutes = require("./routes/patrimonio.routes");
const movimientoRoutes = require("./routes/movimiento.routes");
// rutas para inventario
const categoriainventarioRoutes = require("./routes/categoriainventario.routes");
const almacenRoutes = require("./routes/almacen.routes");
const subcategoriainventarioRoutes = require("./routes/subcategoriainventario.routes");
const insumoRoutes = require("./routes/insumo.routes");
const inventarioRoutes = require("./routes/inventario.routes");
const kardexRoutes = require("./routes/kardex.routes");
// rutas para rrhh
const tipocpdfRoutes = require("./routes/tipodocpdf.routes");
const documentoRoutes = require("./routes/documento.routes");
const evaluacionRoutes = require("./routes/evaluacion.routes");
const pagoRoutes = require("./routes/pago.routes");
const historiallaboralRoutes = require("./routes/historiallaboral.routes");
// rutas para paciente
const tipoconcentimientoRoutes = require("./routes/tipoconcentimiento.routes");
const diagnosticoRoutes = require("./routes/diagnostico.routes");
const procedimientoRoutes = require("./routes/procedimiento.routes");
const fotosRoutes = require("./routes/fotos.routes");
const enfermedadactualRoutes = require("./routes/enfermedadactual.routes");
const exploracionfisicaRoutes = require("./routes/exploracionfisica.routes");
const evolucionRoutes = require("./routes/evolucion.routes");
const concentimientoRoutes = require("./routes/concentimiento.routes");
const recetaRoutes = require("./routes/receta.routes");
const plantratamientoRoutes = require("./routes/plantratamiento.routes");
const itemrecetaRoutes = require("./routes/itemreceta.routes");
const tratamientoRoutes = require("./routes/tratamiento.routes");
const cronologiaRoutes = require("./routes/cronologia.routes");
// rutas para odontograma
const cuadranteRoutes = require("./routes/cuadrante.routes");
const ubicacionRoutes = require("./routes/ubicacion.routes");
const dienteRoutes = require("./routes/diente.routes");
const odontogramaclinicoRoutes = require("./routes/odontogramaclinico.routes");
const odontogramaeconomicoRoutes = require("./routes/odontogramaeconomico.routes");
const estadodienteRoutes = require("./routes/estadodiente.routes");
const dienteclinicoRoutes = require("./routes/dienteclinico.routes");
const dienteeconomicoRoutes = require("./routes/dienteeconomico.routes");
// para laboratorio
const laboratorioRoutes = require("./routes/laboratorio.routes");
const empresalaboratorioRoutes = require("./routes/empresalaboratorio.routes");
const ordenlaboratorioRoutes = require("./routes/ordenlaboratorio.routes");
const itemlaboratorioRoutes = require("./routes/itemlaboratorio.routes");
const subitemlaboratorioRoutes = require("./routes/subitemlaboratorio.routes");
const peticionlaboratorioRoutes = require("./routes/peticionlaboratorio.routes");
const resultadolaboratorioRoutes = require("./routes/resultadolaboratorio.routes");
const itemresultadolaboratorioRoutes = require("./routes/itemresultadolaboratorio.routes");
// // para radiografia
const radiografiaRoutes = require("./routes/radiografia.routes");
const empresaradiografiaRoutes = require("./routes/empresaradiografia.routes");
const ordenradiografiaRoutes = require("./routes/ordenradiografia.routes");
const itemradiografiaRoutes = require("./routes/itemradiografia.routes");
const resultadoradiografiaRoutes = require("./routes/resultadoradiografia.routes");
const peticionradiografiaRoutes = require("./routes/peticionradiografia.routes");
const itemresultadoradiografiaRoutes = require("./routes/itemresultadoradiografia.routes");
// rutas agendamiento - paciente - usuario
const usuarioRoutes = require("./routes/usuario.routes");
const pacienteRoutes = require("./routes/paciente.routes");
const ubicacionpersonaRoutes = require("./routes/ubicacionpersona.routes");
const agendamientoRoutes = require("./routes/agendamiento.routes");
const familiarRoutes = require("./routes/familiar.routes");
const coverturaRoutes = require("./routes/covertura.routes");
const atiendeRoutes = require("./routes/atiende.routes");
const autenticacionRoutes = require("./routes/autenticacion.routes");
const auditoriaRoutes = require("./routes/auditoria.routes");
// rutas de economia
const proveedorRoutes = require("./routes/proveedor.routes");
const hallazgoRoutes = require("./routes/hallazgo.routes");
const categoriaRoutes = require("./routes/categoria.routes");
const catalogoRoutes = require("./routes/catalogo.routes");
const tarifarioRoutes = require("./routes/tarifario.routes");
const egresoRoutes = require("./routes/egreso.routes");
const ingresoRoutes = require("./routes/ingreso.routes");
const presupuestoparcialRoutes = require("./routes/presupuestoparcial.routes");
const presupuestototalRoutes = require("./routes/presupuestototal.routes");
const facturaRoutes = require("./routes/factura.routes");
const facturacionRoutes = require("./routes/facturacion.routes");
const itemfacturaRoutes = require("./routes/itemlfactura.routes");
const emisionfacturaRoutes = require("./routes/emitirfactura.routes");
const emisionboletaRoutes = require("./routes/emitirboleta.routes");
const reporteRoutes = require("./routes/reporte.routes");

dotenv.config();

// Inicialización de la aplicación
const app = express();
const PORT = process.env.PORT || 3000;

// Seguridad en encabezados HTTP
app.use(helmet());

// Sanitizar datos contra NoSQL Injection
app.use(mongoSanitize());

// Prevenir ataques XSS (Cross-Site Scripting)
app.use(xss());

// aplicando cors
const corsOptions = {
  origin: [
    "https://dashboard.clinicadentalimagensac.com",
    "https://dashboardodontologico.clinicadentalimagensac.com",
    "https://externo.clinicadentalimagensac.com",
    "https://clinicadentalimagensac.com",
    "http://localhost:4200",
    "https://localhost:4201",
    "http://localhost:4202",
  ],
  // , // Solo permite este dominio
  methods: "GET,POST,PUT,DELETE,OPTIONS,PATCH,HEAD,CONNECT,TRACE,SEARCH",
  allowedHeaders: "Content-Type,Authorization",
};

app.use(cors(corsOptions));

// Middleware
app.use(express.json());

// Middleware para registrar peticiones HTTP
app.use(
  morgan(":method :url :status :res[content-length] - :response-time ms", {
    stream: {
      write: (message) => logger.info(message.trim()),
    },
  })
);
// Documentación con Swagger
swaggerDocs(app);

// Servir archivos estáticos desde la carpeta "public"
app.use(express.static(path.join(__dirname, 'public')));

// Ruta principal para servir la página
app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, 'public', 'index.html'));
});
// ruta para los logs
app.use("/logs", logRoutes);
// ruta para datos
app.use("/data", dataRoutes);
// Rutas de api generales
// ruta para datos
app.use("/datos", datosRoutes);
app.use("/generales/estadoagendamiento", estadoagendamientoRoutes);
app.use("/generales/estadoincidencia", estadoincidenciaRoutes);
app.use("/generales/estadopago", estadopagoRoutes);
app.use("/generales/estadocampania", estadocampaniaRoutes);
app.use("/generales/estadoordenlaboratorio", estadoordenlaboratorioRoutes);
app.use("/generales/estadousuario", estadousuarioRoutes);
app.use("/generales/fuentecaptacion", fuentecaptacionRoutes);
app.use("/generales/genero", generoRoutes);
app.use("/generales/gradoinstruccion", gradoinstruccionRoutes);
app.use("/generales/relacion", relacionRoutes);
app.use("/generales/vinculacion", vinculacionRoutes);
app.use("/generales/tipoafiliacion", tipoafiliacionRoutes);
app.use("/generales/tipodocumento", tipodocumentoRoutes);
app.use("/generales/tipoincidencia", tipoincidenciaRoutes);
app.use("/generales/tipoingreso", tipoingresoRoutes);
app.use("/generales/tipoproveedor", tipoproveedorRoutes);
app.use("/generales/tipocampania", tipocampaniaRoutes);
app.use("/generales/tipoactividad", tipoactividadRoutes);
app.use("/generales/tiporespuesta", tiporespuestaRoutes);
app.use("/generales/tipopago", tipopagoRoutes);
app.use("/generales/tipousuario", tipousuarioRoutes);
app.use("/generales/periodo", periodoRoutes);
app.use("/generales/iafa", iafaRoutes); // tiene token
// Rutas de api pilares
app.use("/pilares/servicio", servicioRoutes);
app.use("/pilares/profesion", profecionRoutes);
app.use("/pilares/cargousuario", cargousuarioRoutes);
app.use("/pilares/empresa", empresaRoutes); // tiene token
app.use("/pilares/sede", sedeRoutes); // tiene token
app.use("/pilares/consultorio", consultorioRoutes); // tiene token
// rutas api para las incidencias
app.use("/incidencia/cliente", clienteRoutes); // tiene token
app.use("/incidencia/incidencia", incidenciaRoutes); // tiene token
app.use("/incidencia/incidenciadetalle", incidenciadetalleRoutes); // tiene token
app.use("/incidencia/accion", accionRoutes); // tiene token
// rutas api para las encuestas
app.use("/encuesta/simple", encuestasimpleRoutes); // tiene token
app.use("/encuesta/kids", encuestakidsRoutes); // tiene token
app.use("/encuesta/compleja", encuestacomplejaRoutes); // tiene token
// Rutas de api patrimonio
app.use("/patrimonio/categoria", categoriapatrimonioRoutes);
app.use("/patrimonio/subcategoria", subcategoriapatrimonioRoutes);
app.use("/patrimonio/patrimonio", patrimonioRoutes); // tiene token
app.use("/patrimonio/movimiento", movimientoRoutes); // tiene token
// Rutas de api inventario
app.use("/inventario/categoria", categoriainventarioRoutes);
app.use("/inventario/subcategoria", subcategoriainventarioRoutes); 
app.use("/inventario/almacen", almacenRoutes);  // tiene token
app.use("/inventario/insumo", insumoRoutes);  // tiene token
app.use("/inventario/inventario", inventarioRoutes);  // tiene token
app.use("/inventario/kardex", kardexRoutes);  // tiene token
// Rutas de api RRHH
app.use("/rrhh/tipocpdf", tipocpdfRoutes);
app.use("/rrhh/documento", documentoRoutes);  // tiene token
app.use("/rrhh/evaluacion", evaluacionRoutes);  // tiene token
app.use("/rrhh/pago", pagoRoutes);  // tiene token
app.use("/rrhh/historiallaboral", historiallaboralRoutes);  // tiene token
// rutas para paciente
app.use("/historiaclinica/tipoconcentimiento", tipoconcentimientoRoutes);
app.use("/historiaclinica/diagnostico", diagnosticoRoutes);
app.use("/historiaclinica/procedimiento", procedimientoRoutes);
app.use("/historiaclinica/fotos", fotosRoutes); // tiene token
app.use("/historiaclinica/enfermedadactual", enfermedadactualRoutes); // tiene token
app.use("/historiaclinica/exploracionfisica", exploracionfisicaRoutes); // tiene token
app.use("/historiaclinica/evolucion", evolucionRoutes); // tiene token
app.use("/historiaclinica/concentimiento", concentimientoRoutes); // tiene token
app.use("/historiaclinica/receta", recetaRoutes); // tiene token
app.use("/historiaclinica/plantratamiento", plantratamientoRoutes); // tiene token
app.use("/historiaclinica/itemreceta", itemrecetaRoutes); // tiene token
app.use("/historiaclinica/tratamiento", tratamientoRoutes); // tiene token
app.use("/historiaclinica/cronologia", cronologiaRoutes); // tiene token
// rutas para odontograma
app.use("/odontograma/cuadrante", cuadranteRoutes);
app.use("/odontograma/ubicacion", ubicacionRoutes);
app.use("/odontograma/diente", dienteRoutes);
app.use("/odontograma/odontogramaclinico", odontogramaclinicoRoutes); // tiene token
app.use("/odontograma/odontogramaeconomico", odontogramaeconomicoRoutes); // tiene token
app.use("/odontograma/estadodiente", estadodienteRoutes); // tiene token
app.use("/odontograma/dienteclinico", dienteclinicoRoutes); // tiene token
app.use("/odontograma/dienteeconomico", dienteeconomicoRoutes); // tiene token
// para laboratorio
app.use("/laboratorio/laboratorio", laboratorioRoutes);
app.use("/laboratorio/empresa", empresalaboratorioRoutes);
app.use("/laboratorio/orden", ordenlaboratorioRoutes); // tiene token
app.use("/laboratorio/item", itemlaboratorioRoutes); // tiene token
app.use("/laboratorio/subitem", subitemlaboratorioRoutes); // tiene token
app.use("/laboratorio/peticion", peticionlaboratorioRoutes); // tiene token
app.use("/laboratorio/resultado", resultadolaboratorioRoutes); // tiene token
app.use("/laboratorio/itemresultado", itemresultadolaboratorioRoutes); // tiene token
// para radiografia
app.use("/radiografia/radiografia", radiografiaRoutes);
app.use("/radiografia/empresa", empresaradiografiaRoutes);
app.use("/radiografia/orden", ordenradiografiaRoutes); // tiene token
app.use("/radiografia/item", itemradiografiaRoutes); // tiene token
app.use("/radiografia/peticion", peticionradiografiaRoutes); // tiene token
app.use("/radiografia/resultado", resultadoradiografiaRoutes); // tiene token
app.use("/radiografia/itemresultado", itemresultadoradiografiaRoutes); // tiene token
// Rutas de api agendamiento - paciente - usuario
app.use("/pilar/usuario", usuarioRoutes); // tiene token
app.use("/pilar/paciente", pacienteRoutes); // tiene token
app.use("/pilar/ubicacion", ubicacionpersonaRoutes); // tiene token
app.use("/agenda/agendamiento", agendamientoRoutes); // tiene token
app.use("/pilar/familiar", familiarRoutes); // tiene token
app.use("/economia/covertura", coverturaRoutes); // tiene token
app.use("/agenda/atiende", atiendeRoutes); // tiene token
app.use("/pilar/auth", autenticacionRoutes); // tiene token
app.use("/pilar/auditoria", auditoriaRoutes); // tiene token
// Rutas de api economia
app.use("/economia/proveedor", proveedorRoutes); //tiene token
app.use("/economia/categoria", categoriaRoutes); //tiene token
app.use("/economia/hallazgo", hallazgoRoutes); //tiene token
app.use("/economia/catalogo", catalogoRoutes); //tiene token
app.use("/economia/tarifario", tarifarioRoutes); //tiene token
app.use("/economia/egreso", egresoRoutes); //tiene token
app.use("/economia/ingreso", ingresoRoutes); //tiene token
app.use("/economia/presupuestoparcial", presupuestoparcialRoutes); //tiene token
app.use("/economia/presupuestocovertura", presupuestototalRoutes); //tiene token
app.use("/economia/factura", facturaRoutes); //tiene token
app.use("/economia/facturacion", facturacionRoutes); //tiene token
app.use("/economia/itemfactura", itemfacturaRoutes); //tiene token
app.use("/economia/emisionfactura", emisionfacturaRoutes); //tiene token
app.use("/economia/emisionboleta", emisionboletaRoutes); //tiene token
// ruta para los reportes
app.use("/reporte", reporteRoutes);


// Sincronización con la base de datos
sequelize
  .sync({ alter: true }) // Cambia la estructura sin borrar datos
  .then(() => console.log("✅ Base de datos sincronizada sin perder datos"))
  .catch((err) => console.error("❌ Error al sincronizar la BD:", err));

// Levantar servidor
app.listen(PORT, () => {
  console.log(`Servidor corriendo en el puerto ${PORT}`);
});
